﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SpawnedObjectManager : ScriptableObject
{
    public static List<InteractableObject> spawnedUpgrades = new List<InteractableObject>();
    public static List<InteractableObject> spawnedScrap = new List<InteractableObject>();
    public static List<InteractableObject> redIdleBots = new List<InteractableObject>();
    public static List<InteractableObject> redActiveBots = new List<InteractableObject>();
    public static List<InteractableObject> blueIdleBots = new List<InteractableObject>();
    public static List<InteractableObject> blueActiveBots = new List<InteractableObject>();
    public static List<InteractableObject> redPlayers = new List<InteractableObject>();
    public static List<InteractableObject> bluePlayers = new List<InteractableObject>();

    /// <Summary>
    /// Empties all of the manager's lists. CAUTION: WILL LOSE TRACK OF ALREADY SPAWNED OBJECTS
    /// </Summary>
    public static void ResetObjects()
    {
        spawnedUpgrades = new List<InteractableObject>();
        spawnedScrap = new List<InteractableObject>();
        redIdleBots = new List<InteractableObject>();
        blueIdleBots = new List<InteractableObject>();
        redPlayers = new List<InteractableObject>();
        bluePlayers = new List<InteractableObject>();
    }

    /// <Summary>
    /// Returns the nearest InteractableObject from any of this script's lists.
    /// </Summary>
    public static InteractableObject GetNearest(Vector3 position, List<InteractableObject> list)
    {
        if (list.Count == 0)
        {
            return null;
        }

        float smallestDistance = Mathf.Infinity;
        InteractableObject nearest = null;

        foreach (InteractableObject thing in list)
        {
            if ((position - thing.transform.position).magnitude < smallestDistance)
            {
                smallestDistance = (position - thing.transform.position).magnitude;
                nearest = thing;
            }
        }
        return nearest;
    }

    /// <Summary>
    /// Returns the farthest away InteractableObject from any of this script's lists.
    /// </Summary>
    public static InteractableObject GetFarthest(Vector3 position, List<InteractableObject> list)
    {
        if (list.Count == 0)
        {
            return null;
        }

        float largestDistance = 0;
        InteractableObject farthest = null;

        foreach (InteractableObject thing in list)
        {
            if ((position - thing.transform.position).magnitude > largestDistance)
            {
                largestDistance = (position - thing.transform.position).magnitude;
                farthest = thing;
            }
        }
        return farthest;
    }
}
